/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial;

import java.util.Arrays;
import net.minecraft.world.phys.AABB;
import org.h2.mvstore.rtree.Spatial;

public class SpatialKey
implements Spatial {
    private final long id;
    private final float[] minMax;

    public SpatialKey(long id, AABB aabb) {
        this.id = id;
        this.minMax = new float[]{(float)aabb.f_82288_, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82292_, (float)aabb.f_82290_, (float)aabb.f_82293_};
    }

    public SpatialKey(long id, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.id = id;
        this.minMax = new float[]{minX, maxX, minY, maxY, minZ, maxZ};
    }

    public SpatialKey(long id, SpatialKey other) {
        this.id = id;
        this.minMax = (float[])other.minMax.clone();
    }

    public float min(int dim) {
        return this.minMax[dim + dim];
    }

    public void setMin(int dim, float x) {
        this.minMax[dim + dim] = x;
    }

    public float max(int dim) {
        return this.minMax[dim + dim + 1];
    }

    public void setMax(int dim, float x) {
        this.minMax[dim + dim + 1] = x;
    }

    public Spatial clone(long id) {
        return new SpatialKey(id, this);
    }

    public long getId() {
        return this.id;
    }

    public boolean isNull() {
        return this.minMax.length == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SpatialKey)) {
            return false;
        }
        SpatialKey otherKey = (SpatialKey)other;
        if (this.id != otherKey.id) {
            return false;
        }
        return this.equalsIgnoringId(otherKey);
    }

    public boolean equalsIgnoringId(Spatial other) {
        return Arrays.equals(this.minMax, ((SpatialKey)other).minMax);
    }
}

