/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.geometry;

import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShapeHierarchy<T extends Shape> {
    protected final Long2ObjectMap<Set<T>> sections = new Long2ObjectOpenHashMap();
    protected final AABB aabb;

    public ShapeHierarchy(Iterable<T> shapes) {
        double aabbMinX = Double.MAX_VALUE;
        double aabbMinY = Double.MAX_VALUE;
        double aabbMinZ = Double.MAX_VALUE;
        double aabbMaxX = Double.MIN_VALUE;
        double aabbMaxY = Double.MIN_VALUE;
        double aabbMaxZ = Double.MIN_VALUE;
        for (Shape shape : shapes) {
            AABB boundingBox = shape.getAABB();
            if (boundingBox.f_82288_ < aabbMinX) {
                aabbMinX = boundingBox.f_82288_;
            }
            if (boundingBox.f_82289_ < aabbMinY) {
                aabbMinY = boundingBox.f_82289_;
            }
            if (boundingBox.f_82290_ < aabbMinZ) {
                aabbMinZ = boundingBox.f_82290_;
            }
            if (boundingBox.f_82291_ > aabbMaxX) {
                aabbMaxX = boundingBox.f_82291_;
            }
            if (boundingBox.f_82292_ > aabbMaxY) {
                aabbMaxY = boundingBox.f_82292_;
            }
            if (boundingBox.f_82293_ > aabbMaxZ) {
                aabbMaxZ = boundingBox.f_82293_;
            }
            this.addShapeToSections(shape);
        }
        this.aabb = new AABB(aabbMinX, aabbMinY, aabbMinZ, aabbMaxX, aabbMaxY, aabbMaxZ);
    }

    protected void addShapesToSection(long sectionKey, Collection<T> shapes) {
        ((Set)this.sections.computeIfAbsent(sectionKey, k -> new HashSet())).addAll(shapes);
    }

    protected void addShapeToSections(T shape) {
        AABB boundingBox = shape.getAABB();
        int minSectionX = SectionPos.m_235865_((double)boundingBox.f_82288_);
        int minSectionY = SectionPos.m_235865_((double)boundingBox.f_82289_);
        int minSectionZ = SectionPos.m_235865_((double)boundingBox.f_82290_);
        int maxSectionX = SectionPos.m_235865_((double)boundingBox.f_82291_);
        int maxSectionY = SectionPos.m_235865_((double)boundingBox.f_82292_);
        int maxSectionZ = SectionPos.m_235865_((double)boundingBox.f_82293_);
        for (int y = minSectionY; y <= maxSectionY; ++y) {
            for (int x = minSectionX; x <= maxSectionX; ++x) {
                for (int z = minSectionZ; z <= maxSectionZ; ++z) {
                    ((Set)this.sections.computeIfAbsent(SectionPos.m_123209_((int)x, (int)y, (int)z), k -> new HashSet())).add(shape);
                }
            }
        }
    }

    @Nullable
    protected Set<T> getShapesInSection(double x, double y, double z) {
        int sectionX = SectionPos.m_235865_((double)x);
        int sectionY = SectionPos.m_235865_((double)y);
        int sectionZ = SectionPos.m_235865_((double)z);
        return (Set)this.sections.get(SectionPos.m_123209_((int)sectionX, (int)sectionY, (int)sectionZ));
    }

    public Vec3 getCenter() {
        return this.aabb.m_82399_();
    }

    public double distanceToSqr(double x, double y, double z) {
        double smallestDistSqr = Double.MAX_VALUE;
        Set<T> shapesInSection = this.getShapesInSection(x, y, z);
        if (shapesInSection != null) {
            for (Shape shape : shapesInSection) {
                double distSqr;
                if (!shape.contains(x, y, z) || !((distSqr = shape.distanceToSqr(x, y, z)) < smallestDistSqr)) continue;
                smallestDistSqr = distSqr;
            }
        }
        return smallestDistSqr;
    }

    public AABB getAABB() {
        return this.aabb;
    }

    @Nullable
    public T getClosestShapeContaining(double x, double y, double z) {
        if (!this.aabb.m_82393_(x, y, z)) {
            return null;
        }
        Shape closestShape = null;
        Set<T> shapesInSection = this.getShapesInSection(x, y, z);
        if (shapesInSection != null) {
            double minDistSqr = Double.MAX_VALUE;
            for (Shape shape : shapesInSection) {
                double distSqr;
                if (!shape.contains(x, y, z) || !((distSqr = shape.distanceToSqr(x, y, z)) < minDistSqr)) continue;
                closestShape = shape;
                minDistSqr = distSqr;
            }
        }
        return (T)closestShape;
    }

    @Nullable
    public List<T> getShapesContaining(double x, double y, double z) {
        if (!this.aabb.m_82393_(x, y, z)) {
            return null;
        }
        Set<T> shapesInSection = this.getShapesInSection(x, y, z);
        if (shapesInSection != null) {
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            for (Shape shape : shapesInSection) {
                if (!shape.contains(x, y, z)) continue;
                shapes.add(shape);
            }
            return shapes;
        }
        return null;
    }

    public boolean contains(double x, double y, double z) {
        if (!this.aabb.m_82393_(x, y, z)) {
            return false;
        }
        Set<T> shapesInSection = this.getShapesInSection(x, y, z);
        if (shapesInSection != null) {
            for (Shape shape : shapesInSection) {
                if (!shape.contains(x, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!this.aabb.m_82314_(minX, minY, minZ, maxX, maxY, maxZ)) {
            return false;
        }
        int sectionMinX = SectionPos.m_235865_((double)Mth.m_14008_((double)minX, (double)this.aabb.f_82288_, (double)this.aabb.f_82291_));
        int sectionMinY = SectionPos.m_235865_((double)Mth.m_14008_((double)minY, (double)this.aabb.f_82289_, (double)this.aabb.f_82292_));
        int sectionMinZ = SectionPos.m_235865_((double)Mth.m_14008_((double)minZ, (double)this.aabb.f_82290_, (double)this.aabb.f_82293_));
        int sectionMaxX = SectionPos.m_235865_((double)Mth.m_14008_((double)maxX, (double)this.aabb.f_82288_, (double)this.aabb.f_82291_));
        int sectionMaxY = SectionPos.m_235865_((double)Mth.m_14008_((double)maxY, (double)this.aabb.f_82289_, (double)this.aabb.f_82292_));
        int sectionMaxZ = SectionPos.m_235865_((double)Mth.m_14008_((double)maxZ, (double)this.aabb.f_82290_, (double)this.aabb.f_82293_));
        for (int y = sectionMinY; y <= sectionMaxY; ++y) {
            for (int x = sectionMinX; x <= sectionMaxX; ++x) {
                for (int z = sectionMinZ; z <= sectionMaxZ; ++z) {
                    Set shapesInSection = (Set)this.sections.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
                    if (shapesInSection == null) continue;
                    for (Shape shape : shapesInSection) {
                        if (!shape.intersectsCuboid(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

