/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.geometry;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.spatial.geometry.GeometryUtil;
import com.github.elenterius.biomancy.world.spatial.geometry.HasRadius;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.type.ShapeSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SphereShape
implements Shape,
HasRadius {
    private final Vec3 origin;
    private final float radius;
    private final AABB aabb;

    public SphereShape(Vec3 origin, float radius) {
        this.origin = origin;
        this.radius = radius;
        this.aabb = new AABB(origin.f_82479_ - (double)radius, origin.f_82480_ - (double)radius, origin.f_82481_ - (double)radius, origin.f_82479_ + (double)radius, origin.f_82480_ + (double)radius, origin.f_82481_ + (double)radius);
    }

    public SphereShape(double x, double y, double z, float radius) {
        this(new Vec3(x, y, z), radius);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.origin.m_82531_(x, y, z) < (double)(this.radius * this.radius);
    }

    @Override
    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3 closestPoint = GeometryUtil.closestPointOnAABB(minX, minY, minZ, maxX, maxY, maxZ, this.origin);
        double distSqr = closestPoint.m_82557_(this.origin);
        return distSqr < (double)(this.radius * this.radius);
    }

    @Override
    public Vec3 center() {
        return this.origin;
    }

    @Override
    public double distanceToSqr(double x, double y, double z) {
        return this.origin.m_82531_(x, y, z);
    }

    @Override
    public AABB getAABB() {
        return this.aabb;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public NBTSerializer<Shape> getNBTSerializer() {
        return ShapeSerializers.SPHERE_SERIALIZER;
    }

    public record Serializer(String id) implements NBTSerializer<SphereShape>
    {
        @Override
        public CompoundTag write(SphereShape shape) {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("Radius", shape.radius);
            tag.m_128347_("X", shape.origin.f_82479_);
            tag.m_128347_("Y", shape.origin.f_82480_);
            tag.m_128347_("Z", shape.origin.f_82481_);
            return tag;
        }

        @Override
        public SphereShape read(CompoundTag tag) {
            float radius = tag.m_128457_("Radius");
            double x = tag.m_128459_("X");
            double y = tag.m_128459_("Y");
            double z = tag.m_128459_("Z");
            return new SphereShape(x, y, z, radius);
        }
    }
}

