/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ReflectJavaValueParameter
extends ReflectJavaElement
implements JavaValueParameter {
    private final ReflectJavaType type;
    private final Annotation[] reflectAnnotations;
    private final String reflectName;
    private final boolean isVararg;

    public ReflectJavaValueParameter(ReflectJavaType reflectJavaType, Annotation[] annotationArray, String string, boolean bl) {
        Intrinsics.checkNotNullParameter(reflectJavaType, "type");
        Intrinsics.checkNotNullParameter(annotationArray, "reflectAnnotations");
        this.type = reflectJavaType;
        this.reflectAnnotations = annotationArray;
        this.reflectName = string;
        this.isVararg = bl;
    }

    @Override
    public ReflectJavaType getType() {
        return this.type;
    }

    @Override
    public boolean isVararg() {
        return this.isVararg;
    }

    @Override
    public List getAnnotations() {
        return ReflectJavaAnnotationOwnerKt.getAnnotations(this.reflectAnnotations);
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return ReflectJavaAnnotationOwnerKt.findAnnotation(this.reflectAnnotations, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public Name getName() {
        String string = ((ReflectJavaValueParameter)((Object)string)).reflectName;
        return string != null ? Name.guessByFirstCharacter(string) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(ReflectJavaValueParameter.class.getName()).append(": ");
        String string = this.isVararg() ? "vararg " : "";
        return stringBuilder.append(string).append(this.getName()).append(": ").append(this.getType()).toString();
    }
}

