/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils$SpecialType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public abstract class TypeUtils {
    public static final SimpleType DONT_CARE;
    public static final SimpleType CANNOT_INFER_FUNCTION_PARAM_TYPE;
    public static final SimpleType NO_EXPECTED_TYPE;
    public static final SimpleType UNIT_EXPECTED_TYPE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean noExpectedType(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(0);
        }
        return kotlinType == NO_EXPECTED_TYPE || kotlinType == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(KotlinType kotlinType) {
        return kotlinType != null && kotlinType.getConstructor() == DONT_CARE.getConstructor();
    }

    public static KotlinType makeNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(1);
        }
        return TypeUtils.makeNullableAsSpecified(kotlinType, true);
    }

    public static KotlinType makeNotNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(2);
        }
        return TypeUtils.makeNullableAsSpecified(kotlinType, false);
    }

    public static KotlinType makeNullableAsSpecified(KotlinType kotlinType, boolean bl) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(3);
        }
        if ((kotlinType = kotlinType.unwrap().makeNullableAsSpecified(bl)) == null) {
            TypeUtils.$$$reportNull$$$0(4);
        }
        return kotlinType;
    }

    public static SimpleType makeNullableIfNeeded(SimpleType simpleType2, boolean bl) {
        if (simpleType2 == null) {
            TypeUtils.$$$reportNull$$$0(5);
        }
        if (bl) {
            if ((simpleType2 = simpleType2.makeNullableAsSpecified(true)) == null) {
                TypeUtils.$$$reportNull$$$0(6);
            }
            return simpleType2;
        }
        if (simpleType2 == null) {
            TypeUtils.$$$reportNull$$$0(7);
        }
        return simpleType2;
    }

    public static KotlinType makeNullableIfNeeded(KotlinType kotlinType, boolean bl) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(8);
        }
        if (bl) {
            return TypeUtils.makeNullable(kotlinType);
        }
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(9);
        }
        return kotlinType;
    }

    public static SimpleType makeUnsubstitutedType(ClassifierDescriptor annotated, MemberScope memberScope2, Function1 function1) {
        if (ErrorUtils.isError(annotated)) {
            if ((annotated = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, annotated.toString())) == null) {
                TypeUtils.$$$reportNull$$$0(11);
            }
            return annotated;
        }
        return TypeUtils.makeUnsubstitutedType(annotated.getTypeConstructor(), memberScope2, function1);
    }

    public static SimpleType makeUnsubstitutedType(TypeConstructor object, MemberScope memberScope2, Function1 function1) {
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(12);
        }
        if (memberScope2 == null) {
            TypeUtils.$$$reportNull$$$0(13);
        }
        if (function1 == null) {
            TypeUtils.$$$reportNull$$$0(14);
        }
        List list = TypeUtils.getDefaultTypeProjections(object.getParameters());
        object = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), (TypeConstructor)object, list, false, memberScope2, function1);
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(15);
        }
        return object;
    }

    public static List getDefaultTypeProjections(List object) {
        ArrayList<TypeProjectionImpl> arrayList;
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(16);
        }
        ArrayList<TypeProjectionImpl> arrayList2 = arrayList;
        arrayList = new ArrayList<TypeProjectionImpl>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
            arrayList2.add(new TypeProjectionImpl(typeParameterDescriptor.getDefaultType()));
        }
        object = CollectionsKt.toList(arrayList2);
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(17);
        }
        return object;
    }

    public static List getImmediateSupertypes(KotlinType kotlinType) {
        ArrayList<KotlinType> arrayList;
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(18);
        }
        KotlinType kotlinType2 = kotlinType;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(kotlinType2);
        Object object = kotlinType2.getConstructor().getSupertypes();
        ArrayList<KotlinType> arrayList2 = arrayList;
        arrayList = new ArrayList<KotlinType>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            KotlinType kotlinType3 = TypeUtils.createSubstitutedSupertype(kotlinType, (KotlinType)object.next(), typeSubstitutor2);
            if (kotlinType3 == null) continue;
            arrayList2.add(kotlinType3);
        }
        return arrayList2;
    }

    public static KotlinType createSubstitutedSupertype(KotlinType kotlinType, KotlinType kotlinType2, TypeSubstitutor typeSubstitutor2) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(20);
        }
        if (kotlinType2 == null) {
            TypeUtils.$$$reportNull$$$0(21);
        }
        if (typeSubstitutor2 == null) {
            TypeUtils.$$$reportNull$$$0(22);
        }
        if ((kotlinType2 = typeSubstitutor2.substitute(kotlinType2, Variance.INVARIANT)) != null) {
            return TypeUtils.makeNullableIfNeeded(kotlinType2, kotlinType.isMarkedNullable());
        }
        return null;
    }

    public static boolean isNullableType(KotlinType iterator2) {
        if (iterator2 == null) {
            TypeUtils.$$$reportNull$$$0(27);
        }
        if (((KotlinType)((Object)iterator2)).isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible((KotlinType)((Object)iterator2)) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType((KotlinType)((Object)iterator2)).getUpperBound())) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType((KotlinType)((Object)iterator2))) {
            return false;
        }
        if (TypeUtils.isTypeParameter((KotlinType)((Object)iterator2))) {
            return TypeUtils.hasNullableSuperType((KotlinType)((Object)iterator2));
        }
        if ((iterator2 = ((KotlinType)((Object)iterator2)).getConstructor()) instanceof IntersectionTypeConstructor) {
            iterator2 = iterator2.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                if (!TypeUtils.isNullableType((KotlinType)iterator2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean acceptsNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(28);
        }
        if (kotlinType.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(kotlinType) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType(kotlinType).getUpperBound());
    }

    public static boolean hasNullableSuperType(KotlinType object) {
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(29);
        }
        if (((KotlinType)object).getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        object = TypeUtils.getImmediateSupertypes((KotlinType)object).iterator();
        while (object.hasNext()) {
            if (!TypeUtils.isNullableType((KotlinType)object.next())) continue;
            return true;
        }
        return false;
    }

    public static ClassDescriptor getClassDescriptor(KotlinType annotated) {
        if (annotated == null) {
            TypeUtils.$$$reportNull$$$0(30);
        }
        if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            return (ClassDescriptor)annotated;
        }
        return null;
    }

    public static boolean contains(KotlinType kotlinType, Function1 function1) {
        if (function1 == null) {
            TypeUtils.$$$reportNull$$$0(43);
        }
        return TypeUtils.contains(kotlinType, function1, null);
    }

    private static boolean contains(KotlinType iterator2, Function1 function1, SmartSet smartSet) {
        if (function1 == null) {
            TypeUtils.$$$reportNull$$$0(44);
        }
        if (iterator2 == null) {
            return false;
        }
        KotlinType kotlinType = iterator2;
        Object object2 = kotlinType.unwrap();
        if (TypeUtils.noExpectedType(kotlinType)) {
            return (Boolean)function1.invoke(object2);
        }
        if (smartSet != null && smartSet.contains(iterator2)) {
            return false;
        }
        if (((Boolean)function1.invoke(object2)).booleanValue()) {
            return true;
        }
        if (smartSet == null) {
            smartSet = SmartSet.create();
        }
        smartSet.add(iterator2);
        FlexibleType flexibleType = object2 instanceof FlexibleType ? (FlexibleType)object2 : null;
        if (flexibleType != null && (TypeUtils.contains(flexibleType.getLowerBound(), function1, smartSet) || TypeUtils.contains(flexibleType.getUpperBound(), function1, smartSet))) {
            return true;
        }
        if (object2 instanceof DefinitelyNotNullType && TypeUtils.contains(((DefinitelyNotNullType)object2).getOriginal(), function1, smartSet)) {
            return true;
        }
        object2 = ((KotlinType)((Object)iterator2)).getConstructor();
        if (object2 instanceof IntersectionTypeConstructor) {
            iterator2 = ((IntersectionTypeConstructor)object2).getSupertypes().iterator();
            while (iterator2.hasNext()) {
                if (!TypeUtils.contains((KotlinType)iterator2.next(), function1, smartSet)) continue;
                return true;
            }
            return false;
        }
        for (Object object2 : ((KotlinType)((Object)iterator2)).getArguments()) {
            if (object2.isStarProjection() || !TypeUtils.contains(object2.getType(), function1, smartSet)) continue;
            return true;
        }
        return false;
    }

    public static TypeProjection makeStarProjection(TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            TypeUtils.$$$reportNull$$$0(45);
        }
        return new StarProjectionImpl(typeParameterDescriptor);
    }

    public static boolean isTypeParameter(KotlinType kotlinType) {
        boolean bl;
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(59);
        }
        if (TypeUtils.getTypeParameterDescriptorOrNull(kotlinType) == null) {
            kotlinType.getConstructor();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(62);
        }
        if (kotlinType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)kotlinType.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    static {
        $assertionsDisabled = TypeUtils.class.desiredAssertionStatus() ^ true;
        DONT_CARE = ErrorUtils.createErrorType(ErrorTypeKind.DONT_CARE, new String[0]);
        CANNOT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType(ErrorTypeKind.UNINFERRED_LAMBDA_PARAMETER_TYPE, new String[0]);
        NO_EXPECTED_TYPE = new TypeUtils$SpecialType("NO_EXPECTED_TYPE");
        UNIT_EXPECTED_TYPE = new TypeUtils$SpecialType("UNIT_EXPECTED_TYPE");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        int n2;
        Object object;
        switch (n) {
            default: {
                object = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 47: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                object = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 47: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray[0] = "type";
                break;
            }
            case 53: {
                objectArray[0] = "literalTypeConstructor";
                break;
            }
            case 51: 
            case 54: {
                objectArray[0] = "expectedType";
                break;
            }
            case 48: 
            case 49: {
                objectArray[0] = "supertypes";
                break;
            }
            case 46: 
            case 50: {
                objectArray[0] = "numberValueTypeConstructor";
                break;
            }
            case 45: {
                objectArray[0] = "parameterDescriptor";
                break;
            }
            case 43: 
            case 44: {
                objectArray[0] = "isSpecialType";
                break;
            }
            case 42: {
                objectArray[0] = "specialType";
                break;
            }
            case 41: {
                objectArray[0] = "typeParameterConstructors";
                break;
            }
            case 39: {
                objectArray[0] = "typeParameters";
                break;
            }
            case 37: {
                objectArray[0] = "b";
                break;
            }
            case 36: {
                objectArray[0] = "a";
                break;
            }
            case 34: {
                objectArray[0] = "projections";
                break;
            }
            case 32: {
                objectArray[0] = "typeArguments";
                break;
            }
            case 31: 
            case 33: {
                objectArray[0] = "clazz";
                break;
            }
            case 24: {
                objectArray[0] = "result";
                break;
            }
            case 22: {
                objectArray[0] = "substitutor";
                break;
            }
            case 21: {
                objectArray[0] = "superType";
                break;
            }
            case 20: {
                objectArray[0] = "subType";
                break;
            }
            case 16: {
                objectArray[0] = "parameters";
                break;
            }
            case 14: {
                objectArray[0] = "refinedTypeFactory";
                break;
            }
            case 13: {
                objectArray[0] = "unsubstitutedMemberScope";
                break;
            }
            case 12: {
                objectArray[0] = "typeConstructor";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 47: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray[0] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils";
            }
        }
        switch (n) {
            default: {
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils";
                break;
            }
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray[1] = "getPrimitiveNumberType";
                break;
            }
            case 47: {
                objectArray[1] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 35: {
                objectArray[1] = "substituteProjectionsForParameters";
                break;
            }
            case 26: {
                objectArray[1] = "getAllSupertypes";
                break;
            }
            case 19: {
                objectArray[1] = "getImmediateSupertypes";
                break;
            }
            case 17: {
                objectArray[1] = "getDefaultTypeProjections";
                break;
            }
            case 11: 
            case 15: {
                objectArray[1] = "makeUnsubstitutedType";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray[1] = "makeNullableIfNeeded";
                break;
            }
            case 4: {
                objectArray[1] = "makeNullableAsSpecified";
            }
        }
        switch (n) {
            default: {
                objectArray[2] = "noExpectedType";
                break;
            }
            case 62: {
                objectArray[2] = "getTypeParameterDescriptorOrNull";
                break;
            }
            case 61: {
                objectArray[2] = "isNonReifiedTypeParameter";
                break;
            }
            case 60: {
                objectArray[2] = "isReifiedTypeParameter";
                break;
            }
            case 59: {
                objectArray[2] = "isTypeParameter";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: {
                objectArray[2] = "getPrimitiveNumberType";
                break;
            }
            case 49: {
                objectArray[2] = "findByFqName";
                break;
            }
            case 46: 
            case 48: {
                objectArray[2] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 45: {
                objectArray[2] = "makeStarProjection";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray[2] = "contains";
                break;
            }
            case 40: 
            case 41: {
                objectArray[2] = "dependsOnTypeConstructors";
                break;
            }
            case 38: 
            case 39: {
                objectArray[2] = "dependsOnTypeParameters";
                break;
            }
            case 36: 
            case 37: {
                objectArray[2] = "equalTypes";
                break;
            }
            case 33: 
            case 34: {
                objectArray[2] = "substituteProjectionsForParameters";
                break;
            }
            case 31: 
            case 32: {
                objectArray[2] = "substituteParameters";
                break;
            }
            case 30: {
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 29: {
                objectArray[2] = "hasNullableSuperType";
                break;
            }
            case 28: {
                objectArray[2] = "acceptsNullable";
                break;
            }
            case 27: {
                objectArray[2] = "isNullableType";
                break;
            }
            case 25: {
                objectArray[2] = "getAllSupertypes";
                break;
            }
            case 23: 
            case 24: {
                objectArray[2] = "collectAllSupertypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray[2] = "createSubstitutedSupertype";
                break;
            }
            case 18: {
                objectArray[2] = "getImmediateSupertypes";
                break;
            }
            case 16: {
                objectArray[2] = "getDefaultTypeProjections";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray[2] = "makeUnsubstitutedType";
                break;
            }
            case 10: {
                objectArray[2] = "canHaveSubtypes";
                break;
            }
            case 5: 
            case 8: {
                objectArray[2] = "makeNullableIfNeeded";
                break;
            }
            case 3: {
                objectArray[2] = "makeNullableAsSpecified";
                break;
            }
            case 2: {
                objectArray[2] = "makeNotNullable";
                break;
            }
            case 1: {
                objectArray[2] = "makeNullable";
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 47: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
        }
        String string = String.format((String)object, objectArray);
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException(string);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 47: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                IllegalStateException illegalStateException;
                object = illegalStateException;
                illegalStateException = new IllegalStateException(string);
            }
        }
        throw object;
    }
}

