/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.Array2DHashSet$SetIterator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public abstract class Array2DHashSet
implements Set {
    static final /* synthetic */ boolean $assertionsDisabled;
    protected final AbstractEqualityComparator comparator;
    protected Object[][] buckets;
    protected int n = 0;
    protected int threshold = (int)Math.floor(12.0);
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public Array2DHashSet(AbstractEqualityComparator abstractEqualityComparator, int n, int n2) {
        if (abstractEqualityComparator == null) {
            abstractEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = abstractEqualityComparator;
        this.buckets = this.createBuckets(n);
        this.initialBucketCapacity = n2;
    }

    static {
        $assertionsDisabled = Array2DHashSet.class.desiredAssertionStatus() ^ true;
    }

    public final Object getOrAdd(Object object) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(object);
    }

    protected Object getOrAddImpl(Object object) {
        int n = objectArray4.getBucket(object);
        Object[] objectArray = objectArray4.buckets[n];
        if (objectArray == null) {
            Object[] objectArray2 = objectArray4;
            Object[] objectArray3 = objectArray2.createBucket(objectArray2.initialBucketCapacity);
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = object;
            objectArray2.buckets[n] = objectArray4;
            objectArray4.n = objectArray2.n + 1;
            return object;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == null) {
                objectArray[i] = object;
                ++objectArray4.n;
                return object;
            }
            if (!objectArray4.comparator.equals(object2, object)) continue;
            return object2;
        }
        int n2 = objectArray.length;
        Object[] objectArray5 = Arrays.copyOf(objectArray, objectArray.length * 2);
        Object[] objectArray6 = objectArray5;
        objectArray4.buckets[n] = objectArray6;
        objectArray5[n2] = object;
        ++objectArray4.n;
        return object;
    }

    public Object get(Object object) {
        if (object == null) {
            return object;
        }
        Array2DHashSet array2DHashSet = this;
        int n = array2DHashSet.getBucket(object);
        Object[] objectArray = array2DHashSet.buckets[n];
        if (objectArray == null) {
            return null;
        }
        for (Object object2 : objectArray) {
            if (object2 == null) {
                return null;
            }
            if (!this.comparator.equals(object2, object)) continue;
            return object2;
        }
        return null;
    }

    protected final int getBucket(Object object) {
        return this.comparator.hashCode(object) & this.buckets.length - 1;
    }

    @Override
    public int hashCode() {
        int n = MurmurHash.initialize();
        Object[][] objectArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            for (Object object : objectArray2) {
                if (object == null) break;
                n = MurmurHash.update(n, this.comparator.hashCode(object));
            }
        }
        return MurmurHash.finish(n, this.size());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Array2DHashSet)) {
            return false;
        }
        if (((Array2DHashSet)(object = (Array2DHashSet)object)).size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)object);
    }

    protected void expand() {
        Object[][] objectArray = this.buckets;
        Array2DHashSet array2DHashSet = this;
        this.currentPrime += 4;
        int n = objectArray.length * 2;
        Object[][] objectArray2 = array2DHashSet.createBuckets(n);
        int[] nArray = new int[objectArray2.length];
        array2DHashSet.buckets = objectArray2;
        array2DHashSet.threshold = (int)((double)n * 0.75);
        n = array2DHashSet.size();
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray3 = objectArray[i];
            if (objectArray3 == null) continue;
            for (Object object : objectArray3) {
                Object[] objectArray4;
                if (object == null) break;
                int n3 = this.getBucket(object);
                int n4 = nArray[n3];
                if (n4 == 0) {
                    Array2DHashSet array2DHashSet2 = this;
                    objectArray4 = array2DHashSet2.createBucket(array2DHashSet2.initialBucketCapacity);
                    objectArray2[n3] = objectArray4;
                } else {
                    objectArray4 = objectArray2[n3];
                    if (n4 == objectArray4.length) {
                        objectArray4 = Arrays.copyOf(objectArray4, objectArray4.length * 2);
                        objectArray2[n3] = objectArray4;
                    }
                }
                objectArray4[n4] = object;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        if (!$assertionsDisabled && this.n != n) {
            throw new AssertionError();
        }
    }

    @Override
    public final boolean add(Object object) {
        return this.getOrAdd(object) == object;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object object) {
        Array2DHashSet array2DHashSet = this;
        return array2DHashSet.containsFast(array2DHashSet.asElementType(object));
    }

    public boolean containsFast(Object object) {
        if (object == null) {
            return false;
        }
        return this.get(object) != null;
    }

    @Override
    public Iterator iterator() {
        return new Array2DHashSet$SetIterator(this, this.toArray());
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = objectArray.createBucket(objectArray.size());
        int n = 0;
        Object[][] objectArray2 = objectArray.buckets;
        int n2 = objectArray.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray3 = objectArray2[i];
            if (objectArray3 == null) continue;
            for (Object object : objectArray3) {
                if (object == null) break;
                int n3 = n + 1;
                objectArray[n] = object;
                n = n3;
            }
        }
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = Arrays.copyOf(objectArray, this.size());
        }
        int n = 0;
        Object[][] objectArray2 = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray3 = objectArray2[i];
            if (objectArray3 == null) continue;
            for (Object object : objectArray3) {
                if (object == null) break;
                int n3 = n + 1;
                objectArray[n] = object;
                n = n3;
            }
        }
        return objectArray;
    }

    @Override
    public final boolean remove(Object object) {
        Array2DHashSet array2DHashSet = this;
        return array2DHashSet.removeFast(array2DHashSet.asElementType(object));
    }

    public boolean removeFast(Object object) {
        if (object == null) {
            return false;
        }
        Array2DHashSet array2DHashSet = this;
        int n = array2DHashSet.getBucket(object);
        Object[] objectArray = array2DHashSet.buckets[n];
        if (objectArray == null) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == null) {
                return false;
            }
            if (!this.comparator.equals(object2, object)) continue;
            System.arraycopy(objectArray, i + 1, objectArray, i, objectArray.length - i - 1);
            objectArray[objectArray.length - 1] = null;
            --this.n;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection objectArray) {
        if (objectArray instanceof Array2DHashSet) {
            objectArray = ((Array2DHashSet)objectArray).buckets;
            int n = ((Array2DHashSet)objectArray).buckets.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = objectArray[i];
                if (objectArray2 == null) continue;
                for (Object object : objectArray2) {
                    if (object == null) break;
                    Array2DHashSet array2DHashSet = this;
                    if (array2DHashSet.containsFast(array2DHashSet.asElementType(object))) continue;
                    return false;
                }
            }
        } else {
            objectArray = objectArray.iterator();
            while (objectArray.hasNext()) {
                Array2DHashSet array2DHashSet = this;
                if (array2DHashSet.containsFast(array2DHashSet.asElementType(objectArray.next()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            if (this.getOrAdd(e) == e) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        int n = 0;
        Object[][] objectArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            int n4 = 0;
            for (n3 = 0; n3 < objectArray2.length && (object = objectArray2[n3]) != null; ++n3) {
                if (!collection.contains(object)) continue;
                if (n3 != n4) {
                    objectArray2[n4] = objectArray2[n3];
                }
                ++n4;
                ++n;
            }
            n += n4;
            while (n4 < n3) {
                objectArray2[n4] = null;
                ++n4;
            }
        }
        this.n = n;
        return n != this.n;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Array2DHashSet array2DHashSet = this;
            bl |= array2DHashSet.removeFast(array2DHashSet.asElementType(iterator2.next()));
        }
        return bl;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
        this.threshold = (int)Math.floor(12.0);
    }

    public String toString() {
        StringBuilder stringBuilder;
        if (((Array2DHashSet)((Object)stringBuilder2)).size() == 0) {
            return "{}";
        }
        Array2DHashSet array2DHashSet = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append('{');
        boolean bl = true;
        Object[][] objectArray = array2DHashSet.buckets;
        int n = array2DHashSet.buckets.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            for (Object object : objectArray2) {
                if (object == null) break;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(object.toString());
            }
        }
        Object object = stringBuilder2;
        ((StringBuilder)object).append('}');
        return ((StringBuilder)object).toString();
    }

    protected abstract Object asElementType(Object var1);

    protected abstract Object[][] createBuckets(int var1);

    protected abstract Object[] createBucket(int var1);
}

